<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemOrder extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'key',
        'name',
        'quantity',
        'price',
        'tax',
        'discount',
    ];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'key', 'key');
    }

    public function getPriceAttribute($value)
    {
        return number_format($value / 100, 2);
    }

    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = $value * 100;
    }

    public function getTaxAttribute($value)
    {
        return number_format($value / 100, 2);
    }

    public function setTaxAttribute($value)
    {
        $this->attributes['tax'] = $value * 100;
    }

    public function getDiscountAttribute($value)
    {
        return number_format($value / 100, 2);
    }

    public function setDiscountAttribute($value)
    {
        $this->attributes['discount'] = $value * 100;
    }
}
