<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderUser extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'email',
        'phone',
        'address',
        'city',
        'country',
    ];

    public function client()
    {
        return $this->belongsTo(Client::class, 'phone', 'phone');
    }

    public function order()
    {
        return $this->belongsTo(Order::class);
    }
}
