<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use App\Http\Enums\Package\PackageTypeEnum;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Package extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    protected $fillable = [
        'name',
        'price',
        'type',
        'branches',
        'workers',
        'status',
    ];

    protected $translatable = [
        'name',
    ];

    protected $casts = [
        'type' => PackageTypeEnum::class,
    ];

    public function scopeActive($query, $status = 1)
    {
        return $query->where('status', $status);
    }

    public function getPriceAttribute($value)
    {
        return $value / 100;
    }

    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = $value * 100;
    }
}
