<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class PaymentMethod extends Model
{
    use HasFactory, HasTranslations;

    protected $fillable = [
        'name',
        'rule',
        'model',
        'account_name',
        'resource',
    ];

    protected $translatable = [
        'name',
    ];

    protected $casts = [
        'rule' => 'json',
    ];

    public function company()
    {
        return $this->belongsToMany(Company::class);
    }
}
