<?php

namespace App\Models;

use App\Models\Address;
use App\Rules\UniqueCompanyPhone;
use App\Http\Enums\User\UserStatusEnum;
use App\Http\Helper\AccountHelper;
use Illuminate\Database\Eloquent\Model;
use App\Http\Resources\SupplierResource;
use App\Http\Services\Account\AccountService;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Supplier extends Model
{
    use HasFactory, HasTranslations, SoftDeletes;

    const RULES = [
        'code' => 'required',
        'name' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'required|string',
        'phone_2' => 'nullable',
        // 'address_id' => 'required',
        'note' => 'nullable',
        'status' => 'required',
        'company_id' => 'required',
        'group_id' => 'nullable|exists:attributes,id,model,suppliers',
    ];

    protected $fillable = [
        'code',
        'name',
        'phone',
        'phone_2',
        'address_id',
        'note',
        'status',
        'company_id',
        'group_id',
    ];

    public $translatable = ['name'];

    protected $casts = [
        'status' => UserStatusEnum::class,
    ];

    public function blocked()
    {
        return $this->hasOne(BlockSupplier::class);
    }

    public function address()
    {
        return $this->belongsTo(Address::class, 'address_id');
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function bills()
    {
        return $this->morphMany(Bill::class, 'billable');
    }

    public function entries()
    {
        return $this->morphMany(JournalEntry::class, 'type');
    }

    public function group()
    {
        return $this->belongsTo(Attribute::class);
    }

    public function account()
    {
        return AccountService::getAccountForModel(AccountHelper::ACCOUNT_SUPPLIERS);
    }

    public function resolveResource()
    {
        return SupplierResource::class;
    }
}
