<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TimeType extends Model
{
    use HasFactory, HasTranslations;

    const KEY = 'time_type';

    // const ROLE = [
    //     'dropdown_name_ar' => 'required',
    //     'dropdown_name_en' => 'required',
    //     'dropdown_name' => 'nullable',
    // ];

    protected $table = 'dropdown_options';

    protected $translatable  = [
        'dropdown_name',
        'option_value',
    ];

    protected $fillable = [
        'company_id',
        'dropdown_name', // value to show the user in dropdown
        'option_value', // i have no idea what this is
        'option_label', // used in where clause
    ];

    public function company()
    {
        $this->belongsTo(Company::class);
    }

    public static function timeTypes()
    {
        return self::where('option_label', self::KEY);
    }

}
