<?php

namespace App\Models;

use App\Http\Helper\AccountHelper;
use Illuminate\Database\Eloquent\Model;
use App\Http\Resources\TreasuryResource;
use Spatie\Translatable\HasTranslations;
use App\Http\Services\Account\AccountService;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Treasury extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULES = [
        'name' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'required|string',
        'status' => 'required|boolean',
    ];
    protected $fillable = [
        'company_id',
        'branch_id',
        'name',
        'status',
    ];

    protected $translatable = [
        'name',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function resolveResource()
    {
        return TreasuryResource::class;
    }

    public function account()
    {
        return AccountService::getAccountForModel(AccountHelper::ACCOUNT_TREASURIES);
    }
}
