<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Translatable\HasTranslations;

class Vacation extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULES = [
        'name' => 'nullable|array',
        'name_ar' => 'required|string',
        'name_en' => 'required|string',
        'maximum_balance' => 'required|integer',
        'before_request' => 'required|integer',
        'maximum_days_request' => 'required|integer',
        'deducted_weekly' => 'required|boolean',
        'year_to_year' => 'required|boolean',
        'all' => 'required|boolean',
        'status' => 'required|boolean'
    ];

    protected $translatable = [
        'name',
    ];

    protected $fillable = [
        'company_id',
        'name',
        'deducted_weekly',
        'year_to_year',
        'maximum_balance',
        'before_request',
        'maximum_days_request',
        'all',
        'status'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function vacationRequests()
    {
        return $this->hasMany(VacationRequest::class);
    }
}
