<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class VacationRequest extends Model
{
    use HasFactory, SoftDeletes;

    const RULES =  [
        'from' => 'required|date',
        'to' => 'required|date|after:from',
    ];

    const VACATION_PENDING = 0;
    const VACATION_ACCEPTED = 1;
    const VACATION_REJECTED = 2;

    protected $fillable = [
        'employee_id',
        'vacation_id',
        'substitute_employee_id',
        'from',
        'to',
        'accepted',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }

    public function vacation()
    {
        return $this->belongsTo(Vacation::class);
    }

    public function substituteEmployee()
    {
        return $this->belongsTo(Employee::class, 'substitute_employee_id');
    }
}
