<?php

namespace App\Models;

use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Worker extends Authenticatable
{
    use HasFactory, SoftDeletes, HasRoles, HasApiTokens, Notifiable;

    const RULES = [
        'image' => 'nullable|image',
        'status' => 'nullable|boolean',
    ];

    const UPLOADED_FILES = 'uploads/worker';

    protected $fillable = [
        'employee_id',
        'role_id',
        'image',
        'status',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function company()
    {
        return $this->employee->company;
    }

    public function role()
    {
        return $this->belongsTo(Role::class);
    }
}
