<?php

namespace App\Rules;

use App\Models\Account;
use Illuminate\Contracts\Validation\Rule;

class NewAccountValidateType implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(public ?string $parent_id)
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if ($this->parent_id == null) {
            return $value == 'main';
        } else {
            $account = Account::find($this->parent_id);
            return $account->status != 'sub';
        }

        return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        if ($this->parent_id == null) {
            return 'Status must be main if parent id not exists.';
        } else {
            return 'You can not make account inside sub account.';
        }
    }
}
