<?php

namespace App\Rules;

use App\Models\VacationRequest;
use Illuminate\Contracts\Validation\Rule;

class VacationRequestAcceptedCheck implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(public VacationRequest  $vacationRequest)
    {
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return $this->vacationRequest->accepted == VacationRequest::VACATION_PENDING;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'You cant update on this vacation request after change its status.';
    }
}
