<?php

namespace App\Rules;

use App\Http\Helper\CompanyHelper;
use Illuminate\Contracts\Validation\Rule;

class ValidPaymentMethodRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return CompanyHelper::getCompany(request())->paymentMethods()->where('payment_method_id', $value)->exists();
    }

    public function message()
    {
        return 'The selected payment method is not available for the company.';
    }
}
