<?php
namespace App\Trait;

trait ApiTrait
{
    public function apiResponse($code = true, $message = null, $errors = [], $data = [])
    {
        $array = [
            'status'  => $code,
            'message' => $message,
        ];
        if (empty($data) && !empty($errors)) {
            foreach($errors as $key => $val)
            {
                $array['errors'][$key] = $val[0];
            }
        } elseif (!empty($data) && empty($errors)) {
            $array['data'] = $data;
        } else {
            $array['data'] = $data;
            $array['errors'] = $errors;
        }

        return response()->json($array, 200);
    }

    public function with_base($url)
    {
        return "https://managament.ahlanuof.com/public/$url";
    }
}
