<?php

namespace App\Trait;

use App\Models\Journal;
use App\Http\Enums\Bound\BoundTypeEnum;
use App\Http\Services\Account\JournalService;

trait BoundHelperTrait
{
    private function createJournal()
    {
        $sides = $this->getJournalSides();

        JournalService::createJournal(
            date: now(),
            type: Journal::AUTO_TYPE,
            source: 'Bounds',
            description: $this->bound->description,
            file: null,
            employee: null,
            status: true,
            debit: $sides['debit'],
            credit: $sides['credit'],
            journalable: $this->bound,
        );
    }

    private function getJournalSides(): array
    {
        // route payments type sides.
        if (request()->route()->type == strtolower(BoundTypeEnum::PAYMENTS->name)) {
            return $this->paymentTypeEntries();
        }

        // route receivables type sides.
        return $this->receivableTypeEntries();
    }

    private function paymentTypeEntries(): array
    {
        $entries = [];

        $entries['credit'][] =
            [
                'account' => $this->bound->payment->account(),
                'type' => [
                    'type' => $this->bound->payment_type,
                    'id' => $this->bound->payment_id,
                ],
                'amount' => $this->bound->value,
                'entry_type' => "credit",
            ];

        $entries['debit'][] =
            [
                'account' => $this->bound->entry->account(),
                'type' => [
                    'type' => $this->bound->entry_type,
                    'id' => $this->bound->entry_id,
                ],
                'amount' => $this->bound->value,
                'entry_type' => "debit",
            ];

        return $entries;
    }

    private function receivableTypeEntries(): array
    {
        $entries = [];

        $entries['credit'][] =
            [
                'account' => $this->bound->entry->account(),
                'type' => [
                    'type' => $this->bound->entry_type,
                    'id' => $this->bound->entry_id,
                ],
                'amount' => $this->bound->value,
                'entry_type' => "credit",
            ];

        $entries['debit'][] =
            [
                'account' => $this->bound->payment->account(),
                'type' => [
                    'type' => $this->bound->payment_type,
                    'id' => $this->bound->payment_id,
                ],
                'amount' => $this->bound->value,
                'entry_type' => "debit",
            ];

        return $entries;
    }
}
