<?php

namespace Database\Factories;

use App\Models\Address;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Supplier>
 */
class SupplierFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'company_id' => rand(1, 11),
            'code' => rand(200, 20000),
            'name' => [
                'ar' => $this->faker->name,
                'en' => $this->faker->name,
            ],
            'phone' => $this->faker->unique()->phoneNumber,
            'company_id' => rand(100, 110),
            'phone_2' => $this->faker->optional()->phoneNumber,
            'address_id' => function () {
                return Address::create([
                    'post_code' => rand(500, 3000),
                    'address_line' => [
                        'ar' => $this->faker->paragraph(1),
                        'en' => $this->faker->paragraph(1),
                    ]
                ])->id;
            },
            'note' => $this->faker->paragraph(),
            'status' => $this->faker->boolean(),
        ];
    }
}
