<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBillsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bills', function (Blueprint $table) {
            $table->id();

            $table->text('code')->comment('p => purchase, s => sale');
            $table->morphs('billable');
            $table->date('release_date');
            $table->unsignedBigInteger('amount_paid')->default(0);
            $table->unsignedBigInteger('remain')->default(0);
            $table->enum('type', ['sales', 'purchases']);

            $table->unsignedBigInteger('before_discount');
            $table->unsignedBigInteger('total_discount')->default(0);
            $table->unsignedBigInteger('tax_amount')->nullable();

            $table->foreignId('company_id')->nullable()->constrained();
            $table->foreignId('branch_id')->nullable()->constrained();
            $table->foreignId('warehouse_id')->nullable()->constrained();
            // $table->foreignId('delivery_id')->nullable()->constrained();

            $table->string('attachment_file')->nullable();
            $table->text('note')->nullable();
            $table->string('status')->nullable();
            $table->date('date_of_supply')->nullable();

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bills');
    }
}
