<?php

namespace Database\Seeders;

use App\Models\Company;
use App\Events\NewCompany;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class CompanySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        $company = Company::factory(1)->create([
            'email' => 'test@email.com'
        ])->first();

        event(new NewCompany($company));

        Company::factory(10)->create();
    }
}
