<?php

namespace Database\Seeders;

use App\Models\Address;
use App\Models\Country;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $countries = Country::factory(10)->create();

        foreach($countries as $country)
        {
            $cities = Country::factory(5)->create(['country_id' => $country->id]);

            foreach($cities as $city)
            {
                Country::factory(5)->create(['city_id' => $city->id]);
            }
        }

    }
}
