<?php

namespace Database\Seeders;

use App\Models\MainUnit;
use Illuminate\Database\Seeder;

class MainUnitSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $units = [
            [
                'ar' => 'كيلو',
                'en' => 'Kilogram',
            ],
            [
                'ar' => 'طن',
                'en' => 'Ton',
            ],
            [
                'ar' => 'جرام',
                'en' => 'Gram',
            ],
            [
                'ar' => 'لتر',
                'en' => 'Liter',
            ],

        ];

        foreach($units as $unit)
        {
            MainUnit::create([
                'name' => $unit
            ]);
        }
    }
}
