<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            'view',
            'show',
            'create',
            'edit',
            'delete',
        ];

        $models = [
            'products',
            'services',
            'roles',
            'employees',
        ];

        $guards = [
            'worker',
            'company',
        ];

        foreach ($models as $model) {
            foreach ($guards as $guard) {
                foreach ($permissions as $permission) {
                    Permission::create(['guard_name' => $guard, 'name' => $permission . " " . $model]);
                }
            }
        }
    }
}
