<?php
    use App\Models\Setting;
    $setting = Setting::get();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>تحقق البريد الإلكتروني</title>
    <style>
                @import url('https://fonts.googleapis.com/css2?family=Tajawal:wght@200;300;400;500;700;800;900&display=swap');

        body {
            font-family: "Tajawal", sans-serif !important;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            direction: rtl;
        }

        .container {
            max-width: 850px;
            margin: 50px auto;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        }

        .header {
            background-color: #148d94;
            color: rgb(255, 255, 255);
            text-align: center;
            padding: 10px 0;
            font-family: "Tajawal", sans-serif;
        }

        .logo {
            margin: 0px auto;
            display: block;
        }

        .text1,
        .text {
            text-align: center;
            margin: 0;
            padding: 10px;
            color: #000000;
            font-family: "Tajawal", sans-serif;
        }

        .verification-code {
            text-align: center;
            font-size: 22px;
            font-weight: bold;
            color: #000000;
            margin: 0 auto;
            border-radius: 5px;
            font-family: "Tajawal", sans-serif;
        }

        .code {
            display: inline-block;
            text-align: center;
            border: 2px solid #1d6bb6;
            padding: 5px 10px;
            border-radius: 5px;
            font-family: "Tajawal", sans-serif;
        }

        .footer {
            background-color: #24435e;
            color: #fff;
            text-align: center;
            padding: 20px 0;
            font-family: "Tajawal", sans-serif;
        }

        .icon-div {
            display: inline-block;
            margin-top: 10px;
        }

        .icon-span {
            display: inline-block;
            margin: 0 5px;
        }

        .icon-logo {
            height: 25px;
            width: 25px;
            border-radius: 50%;
        }

        .font-normal {
            font-size: 12px;
            color: #fff;
            font-family: "Tajawal", sans-serif;
        }

        .font-black {
            color: black !important;
        }

        .span-center {
            display: block;
            text-align: center;
            font-family: "Tajawal", sans-serif;
        }

        a{
            color: #fff !important;
        }
    </style>
</head>

<body  style="font-family: 'Tajawal', sans-serif !important;">
    <div class="container">
        <div class="header">
            <img src="https://erp.hesabak.com/assets/hesabak-e88ac0ed.png" class="logo" />
            <div>
                <span style="font-family: 'Tajawal', sans-serif !important;">شكرًا لتسجيلك!</span><br>
                <h2 style="color:#fff; font-family:'Tajawal', sans-serif !important;">تحقق البريد الإلكتروني</h2>
            </div>
        </div>
        <p class="text1">عزيزي المستخدم</p>
        <p class="text1">
            شكرًا لتسجيلك . يرجى استخدام رمز التحقق التالي لتنشيط حسابك
        </p>
        <div class="verification-code" style="text-align: center;">
            <span class="code"><?php echo e($code); ?></span>
        </div>
        <p class="text">
            إذا لم تطلب هذا الرمز، يمكنك تجاهل هذا البريد الإلكتروني بأمان
        </p>

        <span class="font-normal font-black span-center">أطيب التحيات</span>
        <span class="font-normal font-black span-center" style="font-weight: 700; margin-bottom: 10px">
            <?php echo e($setting->where('key', 'APP_NAME')->value('value')); ?>

        </span>
        <div class="footer">
            <h5 style="margin: 10px 0; color:#fff">تواصل معنا</h5>
            <span class="font-normal span-center" style="font-weight: 700; margin-bottom: 10px; font-size: 18px">
                <?php echo e($setting->where('key', 'PHONE')->value('value')); ?>

            </span>
            <span class="font-normal span-center" style="font-weight: 700; margin-bottom: 10px; font-size: 18px; color: #fff !important;">
                <?php echo e($setting->where('key', 'EMAIL')->value('value')); ?>

            </span>
            <div class="icon-div">
                <span class="icon-span">
                    <a target="_blank" href="<?php echo e($setting->where('key', 'FACEBOOK')->value('value')); ?>">
                        <img src="<?php echo e(asset('public/' . Setting::UPLOADED_FILES . '/facebook%20(1).jpg')); ?>" class="icon-logo" />
                    </a>
                </span>
                <span class="icon-span">
                    <a target="_blank" href="<?php echo e($setting->where('key', 'X')->value('value')); ?>">
                        <img src="<?php echo e(asset('public/' . Setting::UPLOADED_FILES . '/xTwiter%20(1).png')); ?>" class="icon-logo" />
                    </a>
                </span>
                <span class="icon-span">
                    <a target="_blank" href="<?php echo e($setting->where('key', 'WHATSAPP')->value('value')); ?>">
                        <img src="<?php echo e(asset('public/' . Setting::UPLOADED_FILES . '/whatsapp%20(1).png')); ?>" class="icon-logo" />
                    </a>
                </span>
                <span class="icon-span">
                    <a target="_blank" href="<?php echo e($setting->where('key', 'YOUTUBE')->value('value')); ?>">
                        <img src="<?php echo e(asset('public/' . Setting::UPLOADED_FILES . '/yotube1.png')); ?>" class="icon-logo" style="width: 30px" />
                    </a>
                </span>
                <span class="icon-span">
                    <a target="_blank" href="<?php echo e($setting->where('key', 'INSTA')->value('value')); ?>">
                        <img src="<?php echo e(asset('public/' . Setting::UPLOADED_FILES . '/insta%20(1).jpeg')); ?>" class="icon-logo" style="height: 25px; width: 25px; border-radius: 50%;" />
                    </a>
                </span>
            </div>
        </div>
        <div class="header" style="padding: 10px 0; font-size: 10px">
            جميع الحقوق محفوظة © <?php echo e($setting->where('key', 'APP_NAME')->value('value')); ?>

        </div>
    </div>
</body>

</html>
<?php /**PATH /home/hesabak/public_html/hesabak/resources/views/mail/email-verification.blade.php ENDPATH**/ ?>