<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Client\ClientController;
use App\Http\Controllers\Api\BlockReason\BlockReasonController;
use App\Http\Controllers\Api\Client\Attribute\AttributeController;
use App\Http\Controllers\Api\Client\BlockClient\BlockClientController;
use App\Http\Controllers\Api\Supplier\BlockSupplierController;

Route::group([
    'prefix' => '{model}/{type}/attributes',
    'controller' => AttributeController::class,
    'middleware' => [
        // 'attribute-check',
    ],
], function () {
    Route::get('/',  'index')->where(['model' => 'clients|suppliers', 'type' => 'group|title']);
    Route::post('/', 'store')->where(['model' => 'clients|suppliers', 'type' => 'group|title']);
    Route::get('/{attribute}',  'show')->middleware(['attribute-company'])->where(['model' => 'clients|suppliers', 'type' => 'group|title']);
    Route::put('/{attribute}',  'update')->middleware(['attribute-company'])->where(['model' => 'clients|suppliers', 'type' => 'group|title']);
    Route::delete('/{attribute}',  'destroy')->middleware(['attribute-company'])->where(['model' => 'clients|suppliers', 'type' => 'group|title']);
});

Route::group([
    'prefix' => 'block-reasons',
    'controller' => BlockReasonController::class,
    'middleware' => [
        'check-company-reason'
    ],
], function () {
    Route::get('/',  'index')->withoutMiddleware('check-company-reason');
    Route::post('/', 'store')->withoutMiddleware('check-company-reason');
    Route::get('/{reason}', 'show');
    Route::put('/{reason}',  'update');
    Route::delete('/{reason}',  'destroy');
});

Route::group([
    'prefix' => 'block-clients',
    'controller' => BlockClientController::class,
    'middleware' => [
        // 'check-company-reason'
    ],
], function () {
    Route::get('/',  'index');
    Route::post('/', 'store');
    Route::put('/{blockClient}',  'update');
    Route::delete('/{blockClient}',  'destroy');
});

Route::group([
    'prefix' => 'block-suppliers',
    'controller' => BlockSupplierController::class,
    'middleware' => [
        // 'check-company-reason'
    ],
], function () {
    Route::get('/',  'index');
    Route::get('/{blockSupplier}', 'show');
    Route::post('/', 'store');
    Route::put('/{blockSupplier}',  'update');
    Route::delete('/{blockSupplier}',  'destroy');
});

Route::group([
    'prefix' => 'clients',
    'controller' => ClientController::class,
    'middleware' => [
        'check-client-company'
    ],
], function () {
    Route::get('/',  'index')->withoutMiddleware('check-client-company');
    Route::post('/', 'store')->withoutMiddleware('check-client-company');
    Route::patch('/{client}/add-image',  'addImage');
    Route::patch('/{client}/change-status', 'changeStatus');
    Route::get('/{client}', 'show');
    Route::put('/{client}',  'update');
    Route::delete('/{client}',  'destroy');
});
