<?php

use Illuminate\Support\Facades\Route;
use App\Http\Enums\Order\OrderStatusEnum;
use App\Http\Controllers\Api\Bill\BillController;
use App\Http\Controllers\Api\ChangeLangController;
use App\Http\Controllers\Api\Bound\BoundController;
use App\Http\Controllers\Online\V1\OrderController;
use App\Http\Controllers\Api\Account\LevelController;
use App\Http\Controllers\Api\Company\CompanyController;
use App\Http\Controllers\Api\Company\Tax\TaxController;
use App\Http\Controllers\Api\Product\ProductController;
use App\Http\Controllers\Api\Service\ServiceController;
use App\Http\Controllers\CompanyMainSettingsController;
use App\Http\Controllers\Api\Company\Role\RoleController;
use App\Http\Controllers\Api\Company\SellNatureController;
use App\Http\Controllers\Api\Account\AccountModelController;
use App\Http\Controllers\Api\Company\Worker\WorkerController;
use App\Http\Controllers\Api\Company\Journal\JournalController;
use App\Http\Controllers\Api\Company\Role\PermissionController;
use App\Http\Controllers\Api\Company\Unit\CompanyUnitController;
use App\Http\Controllers\Api\Branch\Warehouse\OpenBalanceController;
use App\Http\Controllers\Api\Company\Company\CompanySecretKeyController;
use App\Http\Controllers\Api\Company\Currency\CompanyCurrencyController;
use App\Http\Controllers\Api\Company\TreasuryBankNetwork\BankController;
use App\Http\Controllers\Api\Company\PaymentMethod\PaymentMethodController;
use App\Http\Controllers\Api\Company\TreasuryBankNetwork\NetworkController;
use App\Http\Controllers\Api\Company\Purchase\PurchaseRequirementController;
use App\Http\Controllers\Api\Company\TreasuryBankNetwork\TreasuryController;

Route::post('/change-lang', ChangeLangController::class);

Route::group([
    'prefix' => 'secret-key',
    'controller' => CompanySecretKeyController::class,
], function () {
    Route::get('/testing', 'testing')->withoutMiddleware('auth:company')->middleware('secret-key-auth');
    Route::get('/', 'index');
    Route::post('/', 'store');
});

Route::get('/account-levels', [LevelController::class, 'index']);

Route::group([
    'prefix' => 'bills',
    'controller' => BillController::class,
], function () {
    Route::get('/{type}/{billType}/', 'index')->where('type', 'sales|purchases')->where('billType', 'invoice|order');
    Route::get('/{type}/{billType}/{bill}',  'show')->where('type', 'sales|purchases')->where('billType', 'invoice|order');
    Route::post('/{type}/{billType}', 'store')->where('type', 'sales|purchases')->where('billType', 'invoice|order');
    Route::put('/{type}/{billType}/{bill}', 'update')->where('type', 'sales|purchases')->where('billType', 'invoice|order');
    Route::delete('/{type}/{billType}/{bill}',  'destroy')->where('type', 'sales|purchases')->where('billType', 'invoice|order');
});

Route::group([
    'prefix' => 'main-settings',
    'controller' => CompanyMainSettingsController::class
], function () {
    Route::get('/',  'index');
    Route::patch('/{companyMainSettings}',  'update')->middleware('company-main-setting');
});

Route::group([
    'prefix' => 'open-balances',
    'controller' => OpenBalanceController::class
], function () {
    Route::post('/',  'store');
});

Route::group([
    'prefix' => 'journals',
    'controller' => JournalController::class
], function () {
    Route::get('/',  'index');
    Route::post('/',  'store');
    Route::get('/testing',  'testing');
    Route::get('/{journal}',  'show');
});


Route::patch('online/orders/{order}/status/{status}', [OrderController::class,  'updateStatus'])->where('status', implode('|', OrderStatusEnum::getOrderStatuses()));
Route::apiResource('online/orders', OrderController::class)->except(['update']);

Route::group([
    'prefix' => 'bounds/{type}',
    'controller' => BoundController::class
], function () {
    Route::get('/',  'index')->where('type', 'payments|receivables');
    Route::post('/',  'store')->where('type', 'payments|receivables');
    Route::get('/{bound}',  'show')->where('type', 'payments|receivables');
    Route::delete('/{bound}',  'destroy')->where('type', 'payments|receivables');
});

Route::group([
    'prefix' => 'accounts-companies-models',
    'controller' => AccountModelController::class
], function () {
    Route::get('/',  'index');
    Route::post('/accounts/{account}/models/{model}',  'store');
    Route::delete('/accounts/{account}/models/{model}',  'destroy');
});

Route::group([
    'prefix' => 'units',
    'controller' => CompanyUnitController::class,
    'middleware' =>
    [
        'company-unit'
    ]
], function () {
    Route::get('/',  'index')->withoutMiddleware('company-unit');
    Route::post('/', 'store')->withoutMiddleware('company-unit');
    Route::put('/{companyUnit}',  'update');
    Route::delete('/{companyUnit}',  'destroy');
});

Route::group([
    'prefix' => 'currencies',
    'controller' => CompanyCurrencyController::class,
    'middleware' =>
    [
        'company-currency'
    ]
], function () {
    Route::get('/',  'index')->withoutMiddleware('company-currency');
    Route::post('/', 'store')->withoutMiddleware('company-currency');
    Route::put('/{companyCurrency}',  'update');
    Route::delete('/{companyCurrency}',  'destroy');
});


Route::group([
    'prefix' => 'products',
    'controller' => ProductController::class,
    'middleware' => [
        'company-product',
        'secret-key-auth',
    ],
], function () {
    Route::get('/',  'index')->withoutMiddleware('company-product');
    Route::post('/', 'store')->withoutMiddleware('company-product');
    Route::get('/{product}', 'show');
    Route::put('/{product}',  'update');
    Route::patch('/{product}',  'changeStatus');
    Route::delete('/{product}',  'destroy');
});

Route::group([
    'prefix' => 'services',
    'controller' => ServiceController::class,
    // 'middleware' => [
    //     'company-product'
    // ],
], function () {
    Route::get('/',  'index');
    Route::post('/', 'store');
    Route::get('/{service}', 'show');
    Route::put('/{service}',  'update');
    Route::delete('/{service}',  'destroy');
});

Route::get('/permissions', [PermissionController::class, 'index']);
Route::group([
    'controller' => RoleController::class,
    'prefix' => 'roles',

], function () {
    Route::get('/', 'index');
    Route::get('/{role}', 'show');
    Route::delete('/{role}', 'destroy');
    Route::post('/{role}/attach-permissions', 'attachPermissions');
    Route::post('/{worker}/attach-worker-permissions', 'attachWorkerPermission');
    Route::post('/', 'store');
});

Route::group([
    'controller' => WorkerController::class,
    'prefix' => 'workers',
], function () {
    Route::get('/', 'index');
    Route::post('/', 'store');
    Route::get('/{worker}', 'show');
    Route::put('/{worker}', 'update');
    Route::delete('/{worker}', 'destroy');
});

Route::group([
    'controller' => TaxController::class,
    'prefix' => 'taxes',
], function () {
    Route::get('/', 'index');
    Route::post('/', 'store');
    Route::get('/{tax}', 'show');
    Route::put('/{tax}', 'update');
    Route::delete('/{tax}', 'destroy');
});

// Route::group([
//     'controller' => PaymentTermController::class,
//     'prefix' => 'payment-terms',
// ], function () {
//     Route::get('/', 'index');
//     Route::post('/', 'store');
//     Route::get('/{paymentTerm}', 'show');
//     Route::put('/{paymentTerm}', 'update');
//     Route::delete('/{paymentTerm}', 'destroy');
// });

// Route::group([
//     'controller' => ShipmentCompanyController::class,
//     'prefix' => 'shipment-companies',
// ], function () {
//     Route::get('/', 'index');
//     Route::post('/', 'store');
//     Route::get('/{shipmentCompany}', 'show');
//     Route::put('/{shipmentCompany}', 'update');
//     Route::delete('/{shipmentCompany}', 'destroy');
// });

Route::group([
    'controller' => PaymentMethodController::class,
    'prefix' => 'payment-methods',
], function () {
    Route::get('/', 'index');
    Route::post('/', 'store');
});

Route::group([
    'controller' => TreasuryController::class,
    'prefix' => 'treasuries',
    'as' => 'treasuries',
], function () {
    Route::get('/', 'index');
    Route::post('/', 'store');
    Route::get('/{treasury}', 'show');
    Route::put('/{treasury}', 'update');
    Route::delete('/{treasury}', 'destroy');
});

Route::group([
    'controller' => BankController::class,
    'prefix' => 'banks',
    'as' => 'banks',
], function () {
    Route::get('/', 'index');
    Route::post('/', 'store');
    Route::get('/{bank}', 'show');
    Route::put('/{bank}', 'update');
    Route::delete('/{bank}', 'destroy');
});

Route::group([
    'controller' => NetworkController::class,
    'prefix' => 'networks',
    'as' => 'networks',
], function () {
    Route::get('/', 'index');
    Route::post('/', 'store');
    Route::get('/{network}', 'show');
    Route::put('/{network}', 'update');
    Route::delete('/{network}', 'destroy');
});

Route::group([
    'controller' => SellNatureController::class,
    'prefix' => 'selling-natures',
], function () {
    Route::get('/', 'index');
    Route::post('/', 'store');
});

Route::get('/purchases-requirements', [PurchaseRequirementController::class, 'index']);

Route::group([
    // 'prefix' => 'companies',
    'controller' => CompanyController::class
], function () {
    Route::get('/',  'index');
    Route::get('/{company}', 'show');
    Route::post('/', 'store');
    Route::put('/{company}',  'update');
    Route::delete('/{company}',  'destroy');
});
