<?php

namespace App\Exports;

use App\Http\Enums\Product\ProductInventoryTypeEnum;
use App\Http\Enums\Product\ProductTypeEnum;
use App\Http\Helper\CompanyHelper;
use App\Models\Account;
use App\Models\Branch;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use App\Models\Category;
use App\Models\CompanyUnit;
use App\Models\Supplier;
use App\Models\Tax;
use Illuminate\Support\Facades\App;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;

class ProductsExport implements FromCollection, WithHeadings, WithEvents
// , WithMultipleSheets
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return collect([]); // Return an empty collection for demonstration
    }

    public function headings(): array
    {
        return [
            'Serial Number', //a
            'Online Link (Code)', //b
            'Bar Code', //c
            'Product Name', //d
            'Description', //e
            'Category', //f
            'Unit', //g
            'Supplier', //h
            'Warehouse - Branch', //i
            'Quantity', //j
            'Buying Price', //k
            'Selling Price', //l
            'Tax', //m
            'Main Unit', //o
            'Virtual Selling', //p
            'Virtual Buying', //q
            'Conversion Factor', //r
            'Minimum', //s
            'Maximum', //t
            'Inventory', //u
            'Type', //v
            'Has Expiration Date', //w
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet;
                // $this->arrayToDropDownListIncExcelColumn($sheet, $this->getCategoriesName(), 'F', 1000);
                $this->arrayToDropDownListIncExcelColumn($sheet, $this->getUnitsName(), 'G', 1000);
                // $this->arrayToDropDownListIncExcelColumn($sheet, $this->getSuppliersName(), 'H', 1000);
                $this->arrayToDropDownListIncExcelColumn($sheet, $this->getWarehouseBranchName(), 'I', 1000);
                $this->arrayToDropDownListIncExcelColumn($sheet, $this->getTaxesRate(), 'M', 1000);
                $this->arrayToDropDownListIncExcelColumn($sheet, $this->getTrueORFalseOptions(), 'N', 1000);
                $this->arrayToDropDownListIncExcelColumn($sheet, $this->getTrueORFalseOptions(), 'O', 1000);
                $this->arrayToDropDownListIncExcelColumn($sheet, $this->getTrueORFalseOptions(), 'P', 1000);
                $this->arrayToDropDownListIncExcelColumn($sheet, $this->getTrueORFalseOptions(), 'V', 1000);
                $this->arrayToDropDownListIncExcelColumn($sheet, $this->getInventoryType(), 'T', 1000);
                $this->arrayToDropDownListIncExcelColumn($sheet, $this->getProductType(), 'U', 1000);
            },
        ];
    }

    private function arrayToDropDownListIncExcelColumn($sheet, $array, $column, $numberOfRows)
    {
        for ($i = 2; $i <= $numberOfRows; $i++) {
            $cell = $sheet->getDelegate()->getCell($column . $i);
            $objValidation = $cell->getDataValidation();
            $objValidation->setType(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST);
            $objValidation->setErrorStyle(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_INFORMATION);
            $objValidation->setAllowBlank(false);
            $objValidation->setShowInputMessage(true);
            $objValidation->setShowErrorMessage(true);
            $objValidation->setShowDropDown(true);
            $objValidation->setFormula1('"' . implode(',', $array) . '"');
        }
    }
    private function getWarehouseBranchName(): array
    {
        $data = [];

        $branches = Branch::where('company_id',  CompanyHelper::getId())->with('warehouses')->get();
        foreach ($branches as $branch) {
            foreach ($branch->warehouses as  $warehouse) {

                $data[] = $warehouse->name . ' - ' . $branch->name;
            }
        }
        return $data;
    }
    private function getUnitsName(): array
    {
        return CompanyUnit::where('company_id', CompanyHelper::getId())->pluck('name')->toArray();
    }
    private function getCategoriesName(): array
    {
        return Category::where('company_id',  CompanyHelper::getId())->pluck('name')->toArray();
    }
    private function getSuppliersName(): array
    {

        return Supplier::where('company_id',  CompanyHelper::getId())->pluck('name')->toArray();
    }
    private function getTaxesRate(): array
    {
        return Tax::where('company_id',  CompanyHelper::getId())->pluck('rate')->toArray();
    }
    private function getInventoryType()
    {
        return ProductInventoryTypeEnum::getArabicTypes();
    }
    private function getProductType()
    {
        return ProductTypeEnum::getArabicTypes();
    }
    private function getTrueORFalseOptions(): array
    {
        return ['نعم', 'لا'];
    }
    private function getAllSubAccounts(): array
    {
        return  Account::where('company_id',  CompanyHelper::getId())->where('status', 'sub')->pluck('name')->toArray();
    }
}
