<?php

namespace App\Http\Controllers\Api\Account;

use App\Models\Account;
use App\Trait\ApiTrait;
use App\Models\MainModel;
use App\Models\ModelGroup;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\ModelGroupResource;


class AccountModelController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view main accounts');

        return $this->apiResponse(
            data: ModelGroupResource::collection(
                ModelGroup::with([
                    'mainModels:id,label',
                    'mainModels.accounts' => fn($q) => $q->where('account_model_group.company_id', CompanyHelper::getId())
                ])
                    ->whereIn('id', [27, 28, 29, 34])->get(['id', 'name'])
            )
        );
    }

    public function store(Account $account, MainModel $model, ModelGroup $group)
    {
        $this->authorize('create main accounts');
        $companyId = CompanyHelper::getId();
        $model->accounts()->wherePivot('group_id', $group->id)->wherePivot('company_id', $companyId)->detach();
        $model->accounts()->attach($account->id, ['group_id' => $group->id,  'company_id' => $companyId]);
        return $this->apiResponse(message: __('messages.account_added_to_model'));
    }

    public function destroy(Account $account, MainModel $model, ModelGroup $group)
    {
        $this->authorize('delete main accounts');
        $model->accounts()->wherePivot('group_id', $group->id)->detach($account->id);
        return $this->apiResponse(message: __('messages.account_removed_from_model'));
    }
}
