<?php

namespace App\Http\Controllers\Api\Admin\Auth;

use App\Models\Admin;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use App\Http\Resources\AdminResource;
use Illuminate\Validation\ValidationException;
use App\Http\Requests\Api\Admin\Admin\Auth\LoginRequest;

class AdminAuthController extends Controller
{
    use ApiTrait;

    public function login(LoginRequest $request)
    {
        $admin = Admin::where('phone', $request->phone)->first();

        if (!$admin || !Hash::check($request->password, $admin->password)) {
            throw ValidationException::withMessages([
                'phone' => __('auth.failed')
            ]);
        }

        return $this->apiResponse(
            data: [
                'user' => AdminResource::make($admin),
                'token' => $admin->createToken('admin')->plainTextToken,
            ],
            message: __('auth.login_successfully'),
        );
    }

    public function logout()
    {
        request()->user('admin')->currentAccessToken()->delete();
        return $this->apiResponse(
            message: __('auth.logged_out_successfully')
        );
    }
}
