<?php

namespace App\Http\Controllers\Api\Admin\Currency;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Admin\Currency\CurrencyRequest;
use App\Http\Resources\CurrencyResource;
use App\Models\MainCurrency;

class CurrencyController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: CurrencyResource::collection(MainCurrency::get()),
        );
    }

    public function store(CurrencyRequest $request)
    {
        return $this->apiResponse(
            data: CurrencyResource::make(MainCurrency::create($request->validated())),
            message: __('messages.currency_created_successfully')
        );
    }

    public function show(MainCurrency $mainCurrency)
    {
        return $this->apiResponse(
            data: CurrencyResource::make($mainCurrency),
        );
    }

    public function update(CurrencyRequest $request, MainCurrency $mainCurrency)
    {
        $mainCurrency->update($request->validated());

        return $this->apiResponse(
            data: CurrencyResource::make($mainCurrency),
            message: __('messages.currency_updated_successfully')
        );
    }

    public function destroy(MainCurrency $mainCurrency)
    {
        $mainCurrency->delete();
        return $this->apiResponse(
            message: __('messages.currency_deleted_successfully')
        );
    }
}
