<?php

namespace App\Http\Controllers\Api\Admin\Feature;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Admin\Feature\StoreFeatureRequest;
use App\Http\Requests\Api\Admin\Feature\UpdateFeatureRequest;
use App\Http\Resources\AdvantageResource;
use App\Http\Resources\AdvantageDetailResorce;
use App\Models\Advantage;
use Illuminate\Http\Request;
use App\Trait\ApiTrait;
use App\Trait\UploadFileTrait;
class FeatureController extends Controller
{
    use ApiTrait, UploadFileTrait;
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return $this->apiResponse(
            data: AdvantageResource::collection(
                Advantage::get()
            )
        );
    }
    
    public function show(Advantage $advantage){
        
        return $this->apiResponse(
            data: AdvantageDetailResorce::make(
              $advantage
            )
        );
        
    }

    /**
     * Show the form for creating a new resource.
     */
  public function store(StoreFeatureRequest $request)
{
    $advantagesCount = Advantage::where('type', 'About')
            ->orWhere('type', 'WhoAreHeader')
            ->count();
            
    if(in_array($request->type, ['WhoAreHeader','About']) &&  $advantagesCount >1){
        
          return $this->apiResponse(code:422,message: __('messages.not allowed to add maximam is one item'));
    }
    $data = $request->validated();
    $imagePath = null;

   if (in_array($request->type, ['WhoAreHeader','About','Feature','Blog'])) {
        $imagePath = $this->uploadFile(Advantage::UPLOADED_FILES, $request->file('image'));
        $data['image'] = $imagePath;
    }


    Advantage::create($data);

    return $this->apiResponse(message: __('messages.location_created_successfully'));
}

   

    

    public function update(UpdateFeatureRequest $request, Advantage $advantage)
    {

         $data = $request->validated();
    $imagePath = null;

   if (in_array($advantage->type, ['WhoAreHeader','About','Feature','Blog'])) {
        $imagePath = $this->uploadFile(Advantage::UPLOADED_FILES, $request->file('image'),$advantage->image);
        $data['image'] = $imagePath;
    }


    $advantage->update($data);


        return $this->apiResponse(message: __('messages.advantage_updated_successfully'));
   
    }

    public function destroy(Advantage $advantage)
    {
        
         if(in_array($advantage->type, ['WhoAreHeader','About'])){
        
          return $this->apiResponse(code:422,message: __('messages.not allowed to delete'));
    }
        $advantage->delete();
        return $this->apiResponse(
            message: __('messages.deleted_successfully')
        );
    }
}
