<?php

namespace App\Http\Controllers\Api\Admin\Package;

use App\Models\Package;
use App\Trait\ApiTrait;
use App\Http\Controllers\Controller;
use App\Http\Resources\PackageResource;
use App\Http\Requests\Api\Admin\Package\PackageRequest;

class PackageController extends Controller
{
    use ApiTrait;

    public function index()
    {
        // dd(Package::with(['features'])->get());
        return $this->apiResponse(
            data: PackageResource::collection(Package::with(['features'])->get()),
        );
    }

    public function store(PackageRequest $request)
    {
        $result = [];

        collect($request->features)->each(function ($feature) use (&$result) {
            $result[$feature['feature_id']] = ['value' => $feature['value']];
        });

        $package = Package::create($request->validated());
        $package->features()->sync($result);

        return $this->apiResponse(
            data: PackageResource::make($package),
            message: __('messages.package_created_successfully')
        );
    }

    public function show(Package $package)
    {
        return $this->apiResponse(
            data: PackageResource::make($package),
        );
    }

    public function update(PackageRequest $request, Package $package)
    {
        $package->update($request->validated());

        $result = [];

        collect($request->features)->each(function ($feature) use (&$result) {
            $result[$feature['feature_id']] = ['value' => $feature['value']];
        });

        $package->features()->sync($result);
        return $this->apiResponse(
            data: PackageResource::make($package),
            message: __('messages.package_updated_successfully')
        );
    }

    public function changeStatus(Package $package)
    {
        $package->update([
            'status' => !$package->status,
        ]);
        return $this->apiResponse(
            data: PackageResource::make($package),
            message: __('messages.package_status_changed_successfully')
        );
    }

    public function destroy(Package $package)
    {
        //check if the package contains subscriptions

        if ($package->subscriptions->isEmpty()) {
            $package->delete();
            return $this->apiResponse(
                message: __('messages.package_deleted_successfully')
            );
        } else {
            return $this->apiResponse(
                message: __('messages.package_delete_fail')
            );
        }
    }
}
