<?php

namespace App\Http\Controllers\Api\BlockReason;

use App\Trait\ApiTrait;
use App\Models\BlockReason;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Resources\BlockReasonResource;
use App\Http\Requests\Api\Client\BlockReason\StoreBlockReasonRequest;
use App\Http\Requests\Api\Client\BlockReason\UpdateBlockReasonRequest;

class BlockReasonController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view block reasons');

        return $this->apiResponse(data: BlockReasonResource::collection(BlockReason::where('company_id', CompanyHelper::getId())->get()));
    }

    public function store(StoreBlockReasonRequest $request)
    {
        $this->authorize('create block reasons');

        $reason = BlockReason::create([
            'company_id' => CompanyHelper::getId(),
            'option_label' => BlockReason::KEY,
            'dropdown_name' => $request->dropdown_name,
            'option_value' => $request->dropdown_name,
        ]);

        return $this->apiResponse(data: BlockReasonResource::make($reason), message: __('messages.reason_created_successfully'));
    }

    public function update(UpdateBlockReasonRequest $request, BlockReason $reason)
    {
        $this->authorize('edit block reasons');

        $reason->update($request->validated());

        return $this->apiResponse(data: BlockReasonResource::make($reason), message: __('messages.block_reason_updated_successfully'));
    }

    public function destroy(BlockReason $reason)
    {
        $this->authorize('delete block reasons');
        $reason->delete();
        return $this->apiResponse(message: __('messages.block_reason_deleted_successfully'));
    }
}
