<?php

namespace App\Http\Controllers\Api\Branch;

use App\Models\Branch;
use App\Models\Address;
use App\Trait\ApiTrait;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\BranchResource;
use App\Http\Requests\Api\Branch\StoreBranchRequest;
use App\Http\Requests\Api\Branch\UpdateBranchRequest;

class BranchController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view branches');

        $branches = auth('worker')->check() ?
            auth('worker')->user()->employee->branches :
            Branch::whereBelongsTo(CompanyHelper::getCompany(request()))->get();

             foreach ($branches as $branch) {
            if ($branch->isOpen()) {
                $branch->update(['is_opened' => 1]);
            } else {
                $branch->update(['is_opened' => 0]);
            }
        }
        return $this->apiResponse(data: BranchResource::collection($branches));
    }

    public function show(Branch $branch)
    {
        $this->authorize('show branches');

        $branch->load([
            'warehouses.account:id,name',
            'deliveries',
            'company.sellNatures',
            'address.area.country',
            'treasuries.account:id,name',
            'banks.account:id,name',
            'networks.account:id,name',
            'services',
             'products.product.units',
            'products.product.tax',
            'products.branchUnits.unit',
        ]);
        return $this->apiResponse(data: BranchResource::make($branch));
    }

    public function branchEmployee(Branch $branch)
    {
        $this->authorize('show branches');

        $branch->load('employees');
        return $this->apiResponse(data: BranchResource::make($branch));
    }

    public function store(StoreBranchRequest $request)
    {
        $this->authorize('create branches');

        $address = Address::create($request->only([
            'address_line',
            'post_code',
            'city_id',
        ]));

        $branch = CompanyHelper::getCompany(request())
            ->branches()
            ->create([
                'address_id' => $address->id,
            ]  + $request->validated());
        $branch->warehouses()->sync($request->warehouses);
        return $this->apiResponse(
            data: BranchResource::make($branch),
            message: __('messages.branches_created_successfully')
        );
    }

    public function update(UpdateBranchRequest $request, Branch $branch)
    {
        $this->authorize('edit branches');

        $address_data = $request->only([
            'address_line',
            'post_code',
            'city_id',
        ]);

        $branch->address()->update($address_data);

        $branch->update($request->validated());

        $warehouseIds = collect($request->warehouses)->pluck('id')->toArray();
        $branch->warehouses()->sync($warehouseIds);

        return $this->apiResponse(data: BranchResource::make($branch), message: __('messages.branches_updated_successfully'));
    }

    public function destroy(Branch $branch)
    {
        $this->authorize('delete branches');

        $branch->delete();
        return $this->apiResponse(message: __('messages.branches_deleted_successfully'));
    }



  public function updateStatus(Branch $branch){

         $status = $branch->status == 1 ? 0 : 1;

            $branch->update([
                "status" =>  $status
                ]);


         return $this->apiResponse(message: __('messages.branche status updated successfully'));

    }


}
