<?php

namespace App\Http\Controllers\Api\Branch;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Models\DismissalNotice;
use App\Http\Controllers\Controller;
use App\Http\Resources\DismissalNoticeResource;
use App\Http\Services\DismissalNotice\DismissalNoticeService;
use App\Http\Requests\Api\DismissalNotice\DismissalNoticeRequest;

class DismissalNoticeController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $this->authorize('view dismissal notices');

        return $this->apiResponse(
            data: DismissalNoticeResource::collection(
                DismissalNotice::when(
                    $request->has('warehouse_id'),
                    fn ($query) => $query->where('warehouse_id', $request->warehouse_id)
                )->when(
                    $request->has('branch_id'),
                    fn ($query) => $query->where('branch_id', $request->branch_id)
                )->when(
                    $request->has('product_id'),
                    fn ($query) => $query->where('product_id', $request->product_id)
                )
                    ->with([
                        'product',
                        'warehouse:id,name',
                        'branch:id,name',
                    ])
                    ->get()
            )
        );
    }

    public function store(DismissalNoticeRequest $request)
    {
        $this->authorize('create dismissal notices');

        return $this->apiResponse(
            data: DismissalNoticeResource::make(DismissalNoticeService::createDismissal($request->validated())),
            message: __('messages.dismissal_notice_created_successfully'),
        );
    }

    public function show(DismissalNotice $dismissalNotice)
    {
        $this->authorize('show dismissal notices');

        $dismissalNotice->load([
            'product',
            'warehouse',
            'branch',
        ]);

        return $this->apiResponse(
            data: DismissalNoticeResource::make($dismissalNotice),
        );
    }

    // public function update(Request $request, DismissalNotice $dismissalNotice)
    // {
    //     //
    // }

    public function destroy(DismissalNotice $dismissalNotice)
    {
        $this->authorize('delete dismissal notices');

        $dismissalNotice->delete();
        return $this->apiResponse(
            message: __('messages.dismissal_notice_deleted_successfully'),
        );
    }
}
