<?php

namespace App\Http\Controllers\Api\Branch;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Models\StockTransfer;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\StockTransferResource;
use App\Http\Services\StockTransfer\StockTransferService;
use App\Http\Requests\Api\StockTransfer\StoreStockTransferRequest;

class StockTransferController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view stock transfer');

        return $this->apiResponse(
            data: StockTransferResource::collection(
                CompanyHelper::getCompany()->stockTransfers()->with([
                    'product',
                    'fromWarehouse:id,name',
                    'toWarehouse:id,name',
                    'fromBranch:id,name',
                    'toBranch:id,name',
                ])->get()
            )
        );
    }

    public function store(StoreStockTransferRequest $request)
    {
        $this->authorize('create stock transfer');

        (new StockTransferService)->processTransfer($request);

        return $this->apiResponse(
            message: __('messages.stock_transfer_created_successfully'),
        );
    }

    public function show(StockTransfer $stockTransfer)
    {
        $this->authorize('show stock transfer');

        $stockTransfer->load([
            'product',
            'fromWarehouse:id,name',
            'toWarehouse:id,name',
            'fromBranch:id,name',
            'toBranch:id,name',
        ]);

        return $this->apiResponse(
            data: StockTransferResource::make($stockTransfer)
        );
    }

    public function destroy(StockTransfer $stockTransfer)
    {
        $this->authorize('delete stock transfer');

        $stockTransfer->delete();
        return $this->apiResponse(
            message: __('messages.stock_transfer_deleted_successfully'),
        );
    }
}
