<?php

namespace App\Http\Controllers\Api\Company\Absence;

use App\Models\Absence;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\AbsenceResource;
use App\Http\Requests\Api\Company\Absence\StoreAbsenceRequest;
use App\Http\Requests\Api\Company\Absence\UpdateAbsenceRequest;

class AbsenceController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $this->authorize('view absences');

        $absences = AbsenceResource::collection($request->user()->absences()->with('employee')->get());
        return $this->apiResponse(data: $absences);
    }

    public function store(StoreAbsenceRequest $request)
    {
        $this->authorize('create absences');

        $absence = new AbsenceResource($request->user()->absences()->create($request->validated()));
        return $this->apiResponse(data: $absence, message: __('messages.absence_created_successfully'));
    }

    public function update(UpdateAbsenceRequest $request, Absence $absence)
    {
        $this->authorize('edit absences');

        $absence->update($request->validated());
        $absence = new AbsenceResource($absence);
        return $this->apiResponse(data: $absence, message: __('messages.absence_updated_successfully'));
    }

    public function destroy(Absence $absence)
    {
        $this->authorize('delete absences');

        $absence->delete();
        return $this->apiResponse(message: __('messages.absence_deleted_successfully'));
    }
}
