<?php

namespace App\Http\Controllers\Api\Company;

use App\Trait\ApiTrait;
use App\Models\AutoShift;
use Illuminate\Http\Request;
use App\Http\Helper\CompanyHelper;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Resources\AutoShiftResource;
use App\Http\Requests\Api\Shift\AutoShift\AutoShiftRequest;

class AutoShiftController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: AutoShiftResource::collection(
                AutoShift::where('company_id', CompanyHelper::getId())->with('branch')->get()
            )
        );
    }

    public function show(AutoShift $autoShift)
    {
        $autoShift->load([
            'branch',
            'autoShiftDetails.worker.employee',
            'autoShiftDetails.treasury',
        ]);

        return $this->apiResponse(
            data: AutoShiftResource::make($autoShift)
        );
    }

    public function store(AutoShiftRequest $request)
    {
        DB::transaction(function () use ($request) {

            $autoShift = AutoShift::create($request->validated());

            foreach ($request->details as $details) {
                $autoShift->autoShiftDetails()->create($details);
            }
        });

        return $this->apiResponse(
            message: __('messages.auto_shift_created_successfully')
        );
    }

    public function update(AutoShift $autoShift, AutoShiftRequest $request)
    {
        DB::transaction(function () use ($request, $autoShift) {

            $autoShift->update(
                $request->only(
                    [
                        'branch_id',
                        'days',
                        'status',
                    ]
                )
            );

            $autoShift->autoShiftDetails()->delete();

            foreach ($request->details as $details) {
                $autoShift->autoShiftDetails()->create($details);
            }
        });

        return $this->apiResponse(
            message: __('messages.auto_shift_updated_successfully')
        );
    }

    public function destroy(AutoShift $autoShift)
    {
        $autoShift->autoShiftDetails()->delete();

        $autoShift->delete();

        return $this->apiResponse(
            message: __('messages.auto_shift_deleted_successfully')
        );
    }
}
