<?php

namespace App\Http\Controllers\Api\Company\Company;

use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;

class CompanySecretKeyController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: ['secret_key' => CompanyHelper::getCompany()->secret_key]
        );
    }

    public function store()
    {
        CompanyHelper::getCompany()->update([
            'secret_key' => CompanyHelper::createSecretKey(),
        ]);

        return $this->apiResponse(
            message: __('messages.key_generated_successfully')
        );
    }
}
