<?php

namespace App\Http\Controllers\Api\Company\Company;

use App\Models\Package;
use App\Trait\ApiTrait;
use App\Jobs\MakeSubscription;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\SubscriptionResource;
use App\Http\Services\Subscription\SubscriptionService;
use App\Http\Requests\Api\Company\Subscribe\SubscribeRequest;

class SubscribeController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $subscriptions = auth('company')->user()->subscriptions()->with(['package.features'])->get();
        return $this->apiResponse(data: SubscriptionResource::collection($subscriptions));
    }

    public function subscribe(SubscribeRequest $request)
    {
        SubscriptionService::handlePackageSubscription(
            company: CompanyHelper::getCompany(),
            package: Package::findOrFail($request->package_id)
        );

        return $this->apiResponse(message: __('messages.successfully_subscribed'));
    }
}
