<?php

namespace App\Http\Controllers\Api\Company\Expense;

use App\Models\Expense;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\ExpenseResource;
use App\Http\Requests\Api\Company\Expense\ExpenseRequest;

class ExpenseController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view expenses');

        return $this->apiResponse(data: ExpenseResource::collection(CompanyHelper::getCompany()->expenses()->with(['account'])->get()));
    }

    public function show(Expense $expense)
    {
        $this->authorize('show expenses');

        $expense->load(['account']);
        return $this->apiResponse(data: ExpenseResource::make($expense));
    }

    public function store(ExpenseRequest $request)
    {
        $this->authorize('create expenses');

        CompanyHelper::getCompany()->expenses()->create($request->validated());
        return $this->apiResponse(message: __('messages.expense_created_successfully'));
    }

    public function update(ExpenseRequest $request, Expense $expense)
    {
        $this->authorize('edit expenses');

        $expense->update($request->validated());
        return $this->apiResponse(message: __('messages.expense_updated_successfully'));
    }

    public function destroy(Expense $expense)
    {
        $this->authorize('delete expenses');

        $expense->delete();
        return $this->apiResponse(message: __('messages.expense_deleted_successfully'));
    }
}
