<?php

namespace App\Http\Controllers\Api\Company\Purchase;

use App\Models\Supplier;
use Illuminate\Http\Request;
use App\Http\Resources\TaxResource;
use App\Models\TreasuryBankNetwork;
use App\Http\Controllers\Controller;
use App\Http\Resources\BranchResource;
use App\Http\Resources\SupplierResource;
use App\Http\Resources\PaymentTermResource;
use App\Http\Resources\PaymentMethodResource;
use App\Http\Resources\ShipmentCompanyResource;
use App\Http\Resources\TreasuryBankNetworkResource;
use App\Trait\ApiTrait;

class PurchaseRequirementController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $suppliers = SupplierResource::collection(Supplier::where('company_id', auth()->id())->get());
        $taxes = TaxResource::collection($request->user()->taxes);
        $paymentTerms = PaymentTermResource::collection($request->user()->paymentTerms);
        $shipmentCompanies = ShipmentCompanyResource::collection($request->user()->shipmentCompanies);
        $paymentMethods = PaymentMethodResource::collection($request->user()->paymentMethods);
        $branches = BranchResource::collection($request->user()->branches);
        $networks = TreasuryBankNetworkResource::collection($request->user()->treasuryBankNetwork(TreasuryBankNetwork::TYPE_NETWORK)->get());
        $treasuries = TreasuryBankNetworkResource::collection($request->user()->treasuryBankNetwork(TreasuryBankNetwork::TYPE_TREASURY)->get());
        $bank = TreasuryBankNetworkResource::collection($request->user()->treasuryBankNetwork(TreasuryBankNetwork::TYPE_BANK)->get());

        return $this->apiResponse(data: [
            'suppliers' => $suppliers,
            'taxes' => $taxes,
            'paymentTerms' => $paymentTerms,
            'shipmentCompanies' => $shipmentCompanies,
            'paymentMethods' => $paymentMethods,
            'branches' => $branches,
            'networks' => $networks,
            'treasuries' => $treasuries,
            'bank' => $bank,
        ]);
    }
}
