<?php

namespace App\Http\Controllers\Api\Company;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Requests\SellNature\StoreSellNatureRequest;
use App\Http\Resources\SellNatureResource;
use App\Models\MainSellNature;
use App\Http\Requests\UpdateSellNatureRequest;
class SellNatureController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $this->authorize('view sell natures');

        return $this->apiResponse(data: [
            "all" => SellNatureResource::collection(MainSellNature::get()),
            "own" => SellNatureResource::collection(CompanyHelper::getCompany($request)->sellNatures),
        ]);
    }

    public function store(StoreSellNatureRequest $request)
    {
        $this->authorize('create sell natures');

        CompanyHelper::getCompany($request)->sellNatures()->sync($request->main_sell_natures);
        return $this->apiResponse(message: __('messages.sell_natures_updated_successfully'));
    }

    public function update(MainSellNature $mainSellNature, UpdateSellNatureRequest $request)
    {

        CompanyHelper::getCompany($request)->sellNatures()->updateExistingPivot($mainSellNature->id, ['label' =>  $request->label]);
        return $this->apiResponse(message: __('messages.sell_natures_updated_successfully'));
    }
}
