<?php

namespace App\Http\Controllers\Api\Company\Step;

use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Models\Step;
use App\Trait\ApiTrait;


class StepController extends Controller
{
    use ApiTrait;

    public function next()
    {
        $company =  CompanyHelper::getCompany();
        $company->increment('steps');
        if ($company->steps >= Step::where('status', true)->count()) {
            $company->update([
                'steps_completed' =>true
            ]);
        }
        return $this->apiResponse(message: __('messages.next_step'));
    }
    public function previous()
    {
        CompanyHelper::getCompany()->decrement('steps');
        return $this->apiResponse(message: __('messages.previous_step'));
    }
}
