<?php

namespace App\Http\Controllers\Api\Company\TreasuryBankNetwork;

use App\Models\Bank;
use App\Trait\ApiTrait;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\BankResource;
use App\Http\Requests\Api\Company\Bank\StoreBankRequest;
use App\Http\Requests\Api\Company\Bank\UpdateBankRequest;

class BankController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view banks');

        return $this->apiResponse(
            data: BankResource::collection(
                CompanyHelper::getCompany()->banks()->with(['account', 'branch'])->get()
            )
        );
    }

    public function store(StoreBankRequest $request)
    {
        $this->authorize('create banks');

        return $this->apiResponse(data: new BankResource(
            CompanyHelper::getCompany()->banks()->create(['company_id' => auth('company')->id()] + $request->validated())
        ), message: __('messages.bank_created_successfully'));
    }

    public function show(Bank $bank)
    {
        $this->authorize('show banks');
        $bank->load(['account', 'branch']);

        return $this->apiResponse(data: new BankResource($bank));
    }

    public function update(UpdateBankRequest $request, Bank $bank)
    {
        $this->authorize('edit banks');

        $bank->update($request->validated());
        return $this->apiResponse(data: new BankResource($bank), message: __('messages.bank_updated_successfully'));
    }

    public function destroy(Bank $bank)
    {
        $this->authorize('delete banks');

        $bank->delete();
        return $this->apiResponse(message: __('messages.bank_deleted_successfully'));
    }
}
