<?php

namespace App\Http\Controllers\Api\Company\TreasuryBankNetwork;

use App\Models\Network;
use App\Trait\ApiTrait;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\NetworkResource;
use App\Http\Requests\Api\Company\Network\StoreNetworkRequest;
use App\Http\Requests\Api\Company\Network\UpdateNetworkRequest;

class NetworkController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view networks');

        return $this->apiResponse(
            data: NetworkResource::collection(
                CompanyHelper::getCompany()->networks()->with(['account', 'branch'])->get()
            )
        );
    }

    public function store(StoreNetworkRequest $request)
    {
        $this->authorize('create networks');

        return $this->apiResponse(
            data: new NetworkResource(Network::create(['company_id' => CompanyHelper::getId()] + $request->validated())),
            message: __('messages.network_created_successfully')
        );
    }

    public function show(Network $network)
    {
        $this->authorize('show networks');

        $network->load(['account', 'branch']);

        return $this->apiResponse(data: new NetworkResource($network));
    }

    public function update(UpdateNetworkRequest $request, Network $network)
    {
        $this->authorize('edit networks');

        $network->update($request->validated());
        return $this->apiResponse(data: new NetworkResource($network), message: __('messages.network_updated_successfully'));
    }

    public function destroy(Network $network)
    {
        $this->authorize('delete networks');

        $network->delete();
        return $this->apiResponse(message: __('messages.network_deleted_successfully'));
    }
}
