<?php

namespace App\Http\Controllers\Api\Company\TreasuryBankNetwork;

use App\Trait\ApiTrait;
use App\Models\Treasury;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Resources\TreasuryResource;
use App\Http\Requests\Api\Company\Treasury\StoreTreasuryRequest;
use App\Http\Requests\Api\Company\Treasury\UpdateTreasuryRequest;

class TreasuryController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view treasuries');

        return $this->apiResponse(
            data: TreasuryResource::collection(Treasury::with(['account', 'branch'])->where('company_id', CompanyHelper::getId())->get())
        );
    }

    public function store(StoreTreasuryRequest $request)
    {
        $this->authorize('create treasuries');

        return $this->apiResponse(
            data: new TreasuryResource(Treasury::with(['branch'])->create(['company_id' => CompanyHelper::getId()] + $request->validated())),
            message: __('messages.treasury_created_successfully')
        );
    }

    public function show(Treasury $treasury)
    {
        $this->authorize('show treasuries');
        $treasury->load(['account', 'branch']);
        return $this->apiResponse(data: new TreasuryResource($treasury));
    }

    public function update(UpdateTreasuryRequest $request, Treasury $treasury)
    {
        $this->authorize('edit treasuries');


        $treasury->update($request->validated());
        return $this->apiResponse(data: new TreasuryResource($treasury), message: __('messages.treasury_updated_successfully'));
    }

    public function destroy(Treasury $treasury)
    {
        $this->authorize('delete treasuries');

        $treasury->delete();
        return $this->apiResponse(message: __('messages.treasury_deleted_successfully'));
    }
}
