<?php

namespace App\Http\Controllers\Api\Company\Vacation;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Company\Vacation\StoreVacationRequest;
use App\Http\Requests\Api\Company\Vacation\UpdateVacationRequest;
use App\Http\Resources\VacationResource;
use App\Models\Vacation;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;

class VacationController extends Controller
{
    use ApiTrait; // authorization

    public function index(Request $request)
    {
        $this->authorize('view vacations');

        $vacations = VacationResource::collection($request->user()->vacations);
        return $this->apiResponse(data: $vacations);
    }

    public function show(Vacation $vacation)
    {
        $this->authorize('show vacations');

        $vacation = new VacationResource($vacation);
        return $this->apiResponse(data: $vacation);
    }

    public function store(StoreVacationRequest $request)
    {
        $this->authorize('create vacations');

        $vacation = new VacationResource($request->user()->vacations()->create($request->validated()));
        return $this->apiResponse(data: $vacation, message: __('messages.vacation_created_successfully'));
    }

    public function update(UpdateVacationRequest $request, Vacation $vacation)
    {
        $this->authorize('edit vacations');

        $vacation->update($request->validated());
        $vacation = new VacationResource($vacation);
        return $this->apiResponse(data: $vacation, message: __('messages.vacation_updated_successfully'));
    }

    public function destroy(Vacation $vacation)
    {
        $this->authorize('delete vacations');

        $vacation->delete();
        return $this->apiResponse(message: __('messages.vacation_deleted_successfully'));
    }
}
