<?php

namespace App\Http\Controllers\Api\Employee;

use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\StoreAppInformationRequest;
use App\Http\Resources\AppInformationResource;
use App\Models\AppInformation;
use App\Trait\UploadFileTrait;

class AppInformationController extends Controller
{
    use UploadFileTrait;

    public function index($type = null)
    {
        $query = AppInformation::where('company_id', CompanyHelper::getId());
        if ($type !== null) {
            $query->where('type', $type);
        }
        if (auth('employee')->user()->section?->id) {
            $query->where('section_id', auth()->user()->section->id);
        }
        return $this->apiResponse(data: AppInformationResource::collection($query->latest()->get()));
    }
    public function store(StoreAppInformationRequest $request)
    {
       
        $file = $request->type === 'audio' ? $this->uploadFile(AppInformation::UPLOADED_FILES, $request->file) : $request->file;
 
        AppInformation::create([
            'file' => $file,
            'company_id' => CompanyHelper::getId(),
            'title' =>  $request->file('file')->getClientOriginalName(),
        ] + $request->validated());
        return $this->apiResponse(message: __('messages.app_information.uploaded.successfully'));
    }
    public function delete(AppInformation $appInformation)
    {
        $appInformation->delete();
        return $this->apiResponse(message: __('messages.app_information.deleted.successfully'));
    }
}
