<?php

namespace App\Http\Controllers\Api\Employee\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Employee\Auth\RegisterRequest;
use App\Models\Employee;
use App\Models\Setting;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
class RegisterController extends Controller
{

    use ApiTrait;
    public function registerStatus()
    {
        $setting = Setting::where("key","Employee_Register")->first();
        $status = $setting ? $setting->value : true;

        return $this->apiResponse(
            data: [
                'status'=> $status == 1,
            ],
            message: "this is register status"

        );
    }


    public function register(RegisterRequest $request){


$employee=Employee::create([
    'password' => Hash::make(Employee::PASSWORD)
    ] + $request->validated()
   );

$token = $employee->createToken('employee')->plainTextToken;
  // $employee->load('branch');
  return $this->apiResponse(
    data: [
        'employee' => $employee,
        'token' => $token,
    ],
    message: "Successfully Logged in."
);


    }
}
