<?php

namespace App\Http\Controllers\Api\Employee\Custody;

use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\CustodyRequest;
use App\Http\Resources\CustodyResource;
use App\Models\Custody;


class CustodyController extends Controller
{


    public function index()
    {
        $this->authorize('view custodies');
        return $this->apiResponse(data: CustodyResource::collection(Custody::with(['employee', 'account', 'custodiesTaken'])->where('company_id', CompanyHelper::getId())->get()));
    }

    public function show(Custody $custody)
    {
        $this->authorize('show custodies');
        $custody->load(['account', 'employee', 'custodiesTaken.entries.journal']);
        return $this->apiResponse(data: CustodyResource::make($custody));
    }

    public function store(CustodyRequest $request)
    {
        $this->authorize('store custodies');
        return $this->apiResponse(data: CustodyResource::make(Custody::create($request->validated())), message: __('messages.custody_created_successfully'));
    }

    public function update(CustodyRequest $request, Custody $custody)
    {
        $this->authorize('edit custodies');
        $custody->update($request->validated());
        return $this->apiResponse(data: CustodyResource::make($custody), message: __('messages.custody_updated_successfully'));
    }

    public function destroy(Custody $custody)
    {
        $this->authorize('delete custodies');
        $custody->delete();
        return $this->apiResponse(message: __('messages.custody_deleted_successfully'));
    }
}
