<?php

namespace App\Http\Controllers\Api\Employee\Custody;

use App\Http\Controllers\Controller;
use App\Http\Requests\CustodyTakenRequest;
use App\Models\CustodyTaken;
use Illuminate\Http\Request;
use App\Trait\ApiTrait;
use App\Http\Resources\CustodyTakenResource;
use App\Http\Services\Custody\CustodyService;

class CustodyTakenController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view custodies');
        return  $this->apiResponse(data: CustodyTakenResource::collection(CustodyTaken::with(['account', 'employee' , 'journals.entries'])->get()));
    }

    public function show(CustodyTaken $custodyTaken)
    {
        $this->authorize('show custodies');
        return $this->apiResponse(data: CustodyTakenResource::make($custodyTaken));
    }

    public function store(CustodyTakenRequest $request)
    {
        $this->authorize('store custodies');
        return $this->apiResponse(
            data: custodyTakenResource::make(
                CustodyService::create($request->validated())
            ),
            message: __('messages.custodyTaken_created_successfully')
        );
    }
}
